package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/edit_garden"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/molders"
)

type EditGardenMae struct {
	AuthorizeStep          *steps.AuthorizeStep
	ConfigureForm          *steps.ConfigureForm
	GardenFetcher          *fetchers.GardenFetcher
	Maestro                *maestro.Maestro
	SetupBreadcrumbStep    *steps.SetupBreadcrumbStep
	UpdateGardenFormMolder *molders.UpdateGardenFormMolder
}

func (this *EditGardenMae) Act(ctx context.Context, in *maes.EditGardenMaeIn) (*maes.EditGardenMaeOut, error) {
	out := &maes.EditGardenMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.EditGardenMaeIn, out *maes.EditGardenMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ConfigureForm.Act,
		this.SetupBreadcrumbStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
