package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/error"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/form_presenters"
	"gardening/src/srv/molders"
)

type ConfigureForm struct {
	GardenTaskFetcher             *fetchers.GardenTaskFetcher
	Maestro                       *maestro.Maestro
	UpdateGardenTaskFormMolder    *molders.UpdateGardenTaskFormMolder
	UpdateGardenTaskFormPresenter *form_presenters.UpdateGardenTaskFormPresenter
}

func (this *ConfigureForm) Act(ctx context.Context, in *maes.EditGardenTaskMaeIn, out *maes.EditGardenTaskMaeOut) (bool, error) {
	mod := this.GardenTaskFetcher.Mod()
	entity, has, err := this.GardenTaskFetcher.FindOneById(ctx, in.Request.Form.Id, mod)
	if !has {
		return false, erro.N("No entity")
	}
	if err != nil {
		return false, err
	}
	this.UpdateGardenTaskFormMolder.ToForm(&out.Response.Form, entity)
	out.Response.Doc = entity
	out.Response.FormBag = this.Maestro.EmptyFormBag()

	out.Response.FormFields = this.UpdateGardenTaskFormPresenter.Setup(&out.Response.Form)

	return true, nil
}
