package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/edit_garden_task"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/molders"
)

type EditGardenTaskMae struct {
	AuthorizeStep              *steps.AuthorizeStep
	ConfigureForm              *steps.ConfigureForm
	GardenTaskFetcher          *fetchers.GardenTaskFetcher
	Maestro                    *maestro.Maestro
	SetupBreadcrumbStep        *steps.SetupBreadcrumbStep
	UpdateGardenTaskFormMolder *molders.UpdateGardenTaskFormMolder
}

func (this *EditGardenTaskMae) Act(ctx context.Context, in *maes.EditGardenTaskMaeIn) (*maes.EditGardenTaskMaeOut, error) {
	out := &maes.EditGardenTaskMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.EditGardenTaskMaeIn, out *maes.EditGardenTaskMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ConfigureForm.Act,
		this.SetupBreadcrumbStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
