package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/error"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/form_presenters"
	"gardening/src/srv/molders"
)

type ConfigureForm struct {
	Maestro                  *maestro.Maestro
	PlantFetcher             *fetchers.PlantFetcher
	UpdatePlantFormMolder    *molders.UpdatePlantFormMolder
	UpdatePlantFormPresenter *form_presenters.UpdatePlantFormPresenter
}

func (this *ConfigureForm) Act(ctx context.Context, in *maes.EditPlantMaeIn, out *maes.EditPlantMaeOut) (bool, error) {
	mod := this.PlantFetcher.Mod()
	entity, has, err := this.PlantFetcher.FindOneById(ctx, in.Request.Form.Id, mod)
	if !has {
		return false, erro.N("No entity")
	}
	if err != nil {
		return false, err
	}
	this.UpdatePlantFormMolder.ToForm(&out.Response.Form, entity)
	out.Response.Doc = entity
	out.Response.FormBag = this.Maestro.EmptyFormBag()

	out.Response.FormFields = this.UpdatePlantFormPresenter.Setup(&out.Response.Form)

	return true, nil
}
