package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/edit_plant"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/molders"
)

type EditPlantMae struct {
	AuthorizeStep         *steps.AuthorizeStep
	ConfigureForm         *steps.ConfigureForm
	Maestro               *maestro.Maestro
	PlantFetcher          *fetchers.PlantFetcher
	SetupBreadcrumbStep   *steps.SetupBreadcrumbStep
	UpdatePlantFormMolder *molders.UpdatePlantFormMolder
}

func (this *EditPlantMae) Act(ctx context.Context, in *maes.EditPlantMaeIn) (*maes.EditPlantMaeOut, error) {
	out := &maes.EditPlantMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.EditPlantMaeIn, out *maes.EditPlantMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ConfigureForm.Act,
		this.SetupBreadcrumbStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
