package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/error"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/form_presenters"
	"gardening/src/srv/molders"
)

type ConfigureForm struct {
	Maestro                      *maestro.Maestro
	PlantTaskFetcher             *fetchers.PlantTaskFetcher
	UpdatePlantTaskFormMolder    *molders.UpdatePlantTaskFormMolder
	UpdatePlantTaskFormPresenter *form_presenters.UpdatePlantTaskFormPresenter
}

func (this *ConfigureForm) Act(ctx context.Context, in *maes.EditPlantTaskMaeIn, out *maes.EditPlantTaskMaeOut) (bool, error) {
	mod := this.PlantTaskFetcher.Mod()
	entity, has, err := this.PlantTaskFetcher.FindOneById(ctx, in.Request.Form.Id, mod)
	if !has {
		return false, erro.N("No entity")
	}
	if err != nil {
		return false, err
	}
	this.UpdatePlantTaskFormMolder.ToForm(&out.Response.Form, entity)
	out.Response.Doc = entity
	out.Response.FormBag = this.Maestro.EmptyFormBag()

	out.Response.FormFields = this.UpdatePlantTaskFormPresenter.Setup(&out.Response.Form)

	return true, nil
}
