package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/edit_plant_task"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/molders"
)

type EditPlantTaskMae struct {
	AuthorizeStep             *steps.AuthorizeStep
	ConfigureForm             *steps.ConfigureForm
	Maestro                   *maestro.Maestro
	PlantTaskFetcher          *fetchers.PlantTaskFetcher
	SetupBreadcrumbStep       *steps.SetupBreadcrumbStep
	UpdatePlantTaskFormMolder *molders.UpdatePlantTaskFormMolder
}

func (this *EditPlantTaskMae) Act(ctx context.Context, in *maes.EditPlantTaskMaeIn) (*maes.EditPlantTaskMaeOut, error) {
	out := &maes.EditPlantTaskMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.EditPlantTaskMaeIn, out *maes.EditPlantTaskMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ConfigureForm.Act,
		this.SetupBreadcrumbStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
