package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/error"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/form_presenters"
	"gardening/src/srv/molders"
)

type ConfigureForm struct {
	Maestro                       *maestro.Maestro
	PlantationFetcher             *fetchers.PlantationFetcher
	UpdatePlantationFormMolder    *molders.UpdatePlantationFormMolder
	UpdatePlantationFormPresenter *form_presenters.UpdatePlantationFormPresenter
}

func (this *ConfigureForm) Act(ctx context.Context, in *maes.EditPlantationMaeIn, out *maes.EditPlantationMaeOut) (bool, error) {
	mod := this.PlantationFetcher.Mod()
	entity, has, err := this.PlantationFetcher.FindOneById(ctx, in.Request.Form.Id, mod)
	if !has {
		return false, erro.N("No entity")
	}
	if err != nil {
		return false, err
	}
	this.UpdatePlantationFormMolder.ToForm(&out.Response.Form, entity)
	out.Response.Doc = entity
	out.Response.FormBag = this.Maestro.EmptyFormBag()

	out.Response.FormFields = this.UpdatePlantationFormPresenter.Setup(&out.Response.Form)

	return true, nil
}
