package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/edit_plantation"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/molders"
)

type EditPlantationMae struct {
	AuthorizeStep              *steps.AuthorizeStep
	ConfigureForm              *steps.ConfigureForm
	Maestro                    *maestro.Maestro
	PlantationFetcher          *fetchers.PlantationFetcher
	SetupBreadcrumbStep        *steps.SetupBreadcrumbStep
	UpdatePlantationFormMolder *molders.UpdatePlantationFormMolder
}

func (this *EditPlantationMae) Act(ctx context.Context, in *maes.EditPlantationMaeIn) (*maes.EditPlantationMaeOut, error) {
	out := &maes.EditPlantationMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.EditPlantationMaeIn, out *maes.EditPlantationMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ConfigureForm.Act,
		this.SetupBreadcrumbStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
