package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/error"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/form_presenters"
	"gardening/src/srv/molders"
)

type ConfigureForm struct {
	Maestro                        *maestro.Maestro
	SeedProgramFetcher             *fetchers.SeedProgramFetcher
	UpdateSeedProgramFormMolder    *molders.UpdateSeedProgramFormMolder
	UpdateSeedProgramFormPresenter *form_presenters.UpdateSeedProgramFormPresenter
}

func (this *ConfigureForm) Act(ctx context.Context, in *maes.EditSeedProgramMaeIn, out *maes.EditSeedProgramMaeOut) (bool, error) {
	mod := this.SeedProgramFetcher.Mod()
	entity, has, err := this.SeedProgramFetcher.FindOneById(ctx, in.Request.Form.Id, mod)
	if !has {
		return false, erro.N("No entity")
	}
	if err != nil {
		return false, err
	}
	this.UpdateSeedProgramFormMolder.ToForm(&out.Response.Form, entity)
	out.Response.Doc = entity
	out.Response.FormBag = this.Maestro.EmptyFormBag()

	out.Response.FormFields = this.UpdateSeedProgramFormPresenter.Setup(&out.Response.Form)

	return true, nil
}
