package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/edit_seed_program"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/molders"
)

type EditSeedProgramMae struct {
	AuthorizeStep               *steps.AuthorizeStep
	ConfigureForm               *steps.ConfigureForm
	Maestro                     *maestro.Maestro
	SeedProgramFetcher          *fetchers.SeedProgramFetcher
	SetupBreadcrumbStep         *steps.SetupBreadcrumbStep
	UpdateSeedProgramFormMolder *molders.UpdateSeedProgramFormMolder
}

func (this *EditSeedProgramMae) Act(ctx context.Context, in *maes.EditSeedProgramMaeIn) (*maes.EditSeedProgramMaeOut, error) {
	out := &maes.EditSeedProgramMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.EditSeedProgramMaeIn, out *maes.EditSeedProgramMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ConfigureForm.Act,
		this.SetupBreadcrumbStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
