package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/error"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/form_presenters"
	"gardening/src/srv/molders"
)

type ConfigureForm struct {
	Maestro                 *maestro.Maestro
	UpdateUserFormMolder    *molders.UpdateUserFormMolder
	UpdateUserFormPresenter *form_presenters.UpdateUserFormPresenter
	UserFetcher             *fetchers.UserFetcher
}

func (this *ConfigureForm) Act(ctx context.Context, in *maes.EditUserMaeIn, out *maes.EditUserMaeOut) (bool, error) {
	mod := this.UserFetcher.Mod()
	entity, has, err := this.UserFetcher.FindOneById(ctx, in.Request.Form.Id, mod)
	if !has {
		return false, erro.N("No entity")
	}
	if err != nil {
		return false, err
	}
	this.UpdateUserFormMolder.ToForm(&out.Response.Form, entity)
	out.Response.Doc = entity
	out.Response.FormBag = this.Maestro.EmptyFormBag()

	out.Response.FormFields = this.UpdateUserFormPresenter.Setup(&out.Response.Form)

	return true, nil
}
