package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/edit_user"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/molders"
)

type EditUserMae struct {
	AuthorizeStep        *steps.AuthorizeStep
	ConfigureForm        *steps.ConfigureForm
	Maestro              *maestro.Maestro
	SetupBreadcrumbStep  *steps.SetupBreadcrumbStep
	UpdateUserFormMolder *molders.UpdateUserFormMolder
	UserFetcher          *fetchers.UserFetcher
}

func (this *EditUserMae) Act(ctx context.Context, in *maes.EditUserMaeIn) (*maes.EditUserMaeOut, error) {
	out := &maes.EditUserMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.EditUserMaeIn, out *maes.EditUserMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ConfigureForm.Act,
		this.SetupBreadcrumbStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
