package steps

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
)

type FetchCounts struct {
	GardenFetcher      *fetchers.GardenFetcher
	GardenTaskFetcher  *fetchers.GardenTaskFetcher
	Maestro            *maestro.Maestro
	PlantFetcher       *fetchers.PlantFetcher
	PlantTaskFetcher   *fetchers.PlantTaskFetcher
	PlantationFetcher  *fetchers.PlantationFetcher
	SeedProgramFetcher *fetchers.SeedProgramFetcher
	UserFetcher        *fetchers.UserFetcher
}

func (this *FetchCounts) Act(ctx context.Context, in *maes.HomeMaeIn, out *maes.HomeMaeOut) (bool, error) {
	out.Response.GardenCount = this.GardenFetcher.CountSet(ctx, this.GardenFetcher.Mod()).Total
	out.Response.GardenTaskCount = this.GardenTaskFetcher.CountSet(ctx, this.GardenTaskFetcher.Mod()).Total
	out.Response.PlantCount = this.PlantFetcher.CountSet(ctx, this.PlantFetcher.Mod()).Total
	out.Response.PlantTaskCount = this.PlantTaskFetcher.CountSet(ctx, this.PlantTaskFetcher.Mod()).Total
	out.Response.PlantationCount = this.PlantationFetcher.CountSet(ctx, this.PlantationFetcher.Mod()).Total
	out.Response.SeedProgramCount = this.SeedProgramFetcher.CountSet(ctx, this.SeedProgramFetcher.Mod()).Total
	out.Response.UserCount = this.UserFetcher.CountSet(ctx, this.UserFetcher.Mod()).Total
	return true, nil
}
