package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/home"
)

type HomeMae struct {
	FetchCounts *steps.FetchCounts
	Maestro     *maestro.Maestro
}

func (this *HomeMae) Act(ctx context.Context, in *maes.HomeMaeIn) (*maes.HomeMaeOut, error) {
	out := &maes.HomeMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.HomeMaeIn, out *maes.HomeMaeOut) (bool, error){
		this.FetchCounts.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
