package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/hydrators"
	"gardening/src/srv/presenters"
)

type AddGardenTaskSetToResponseStep struct {
	GardenTaskFetcher   *fetchers.GardenTaskFetcher
	GardenTaskHydrator  *hydrators.GardenTaskHydrator
	GardenTaskPresenter *presenters.GardenTaskPresenter
	Maestro             *maestro.Maestro
}

func (this *AddGardenTaskSetToResponseStep) Act(ctx context.Context, in *maes.ListGardenTasksMaeIn, out *maes.ListGardenTasksMaeOut) (bool, error) {
	mod := this.GardenTaskFetcher.Mod()
	mod.Page = in.Request.Page
	mod.PerPage = 15
	mod.AllowedFilters = this.GardenTaskPresenter.Filters(ctx)
	mod.ConvertRawFilters(in.Request.Filters)
	page, pagination, err := this.GardenTaskFetcher.FindPage(ctx, mod)
	if err != nil {
		return false, err
	}
	this.GardenTaskHydrator.ManyViaPreset(ctx, page, "list", nil)
	out.Response.GardenTasks = page
	out.Response.GardenTasksPagination = pagination
	columns := this.GardenTaskPresenter.Columns("main")
	columns = this.Maestro.UpdateColumnsVisibility(columns, in.Request.Columns)
	out.Response.List.Columns = columns
	return true, nil
}
