package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/list_garden_tasks"
	"gardening/src/srv/fetchers"
)

type ListGardenTasksMae struct {
	AddGardenTaskSetToResponseStep *steps.AddGardenTaskSetToResponseStep
	AuthorizeStep                  *steps.AuthorizeStep
	GardenTaskFetcher              *fetchers.GardenTaskFetcher
	Maestro                        *maestro.Maestro
	SetupBreadcrumbStep            *steps.SetupBreadcrumbStep
}

func (this *ListGardenTasksMae) Act(ctx context.Context, in *maes.ListGardenTasksMaeIn) (*maes.ListGardenTasksMaeOut, error) {
	out := &maes.ListGardenTasksMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.ListGardenTasksMaeIn, out *maes.ListGardenTasksMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.AddGardenTaskSetToResponseStep.Act,
		this.SetupBreadcrumbStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
