package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/hydrators"
	"gardening/src/srv/presenters"
)

type AddGardenSetToResponseStep struct {
	GardenFetcher   *fetchers.GardenFetcher
	GardenHydrator  *hydrators.GardenHydrator
	GardenPresenter *presenters.GardenPresenter
	Maestro         *maestro.Maestro
}

func (this *AddGardenSetToResponseStep) Act(ctx context.Context, in *maes.ListGardensMaeIn, out *maes.ListGardensMaeOut) (bool, error) {
	mod := this.GardenFetcher.Mod()
	mod.Page = in.Request.Page
	mod.PerPage = 15
	mod.AllowedFilters = this.GardenPresenter.Filters(ctx)
	mod.ConvertRawFilters(in.Request.Filters)
	page, pagination, err := this.GardenFetcher.FindPage(ctx, mod)
	if err != nil {
		return false, err
	}
	this.GardenHydrator.ManyViaPreset(ctx, page, "list", nil)
	out.Response.Gardens = page
	out.Response.GardensPagination = pagination
	columns := this.GardenPresenter.Columns("main")
	columns = this.Maestro.UpdateColumnsVisibility(columns, in.Request.Columns)
	out.Response.List.Columns = columns
	return true, nil
}
