package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/list_gardens"
	"gardening/src/srv/fetchers"
)

type ListGardensMae struct {
	AddGardenSetToResponseStep *steps.AddGardenSetToResponseStep
	AuthorizeStep              *steps.AuthorizeStep
	GardenFetcher              *fetchers.GardenFetcher
	Maestro                    *maestro.Maestro
	SetupBreadcrumbStep        *steps.SetupBreadcrumbStep
}

func (this *ListGardensMae) Act(ctx context.Context, in *maes.ListGardensMaeIn) (*maes.ListGardensMaeOut, error) {
	out := &maes.ListGardensMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.ListGardensMaeIn, out *maes.ListGardensMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.AddGardenSetToResponseStep.Act,
		this.SetupBreadcrumbStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
