package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/hydrators"
	"gardening/src/srv/presenters"
)

type AddPlantTaskSetToResponseStep struct {
	Maestro            *maestro.Maestro
	PlantTaskFetcher   *fetchers.PlantTaskFetcher
	PlantTaskHydrator  *hydrators.PlantTaskHydrator
	PlantTaskPresenter *presenters.PlantTaskPresenter
}

func (this *AddPlantTaskSetToResponseStep) Act(ctx context.Context, in *maes.ListPlantTasksMaeIn, out *maes.ListPlantTasksMaeOut) (bool, error) {
	mod := this.PlantTaskFetcher.Mod()
	mod.Page = in.Request.Page
	mod.PerPage = 15
	mod.AllowedFilters = this.PlantTaskPresenter.Filters(ctx)
	mod.ConvertRawFilters(in.Request.Filters)
	page, pagination, err := this.PlantTaskFetcher.FindPage(ctx, mod)
	if err != nil {
		return false, err
	}
	this.PlantTaskHydrator.ManyViaPreset(ctx, page, "list", nil)
	out.Response.PlantTasks = page
	out.Response.PlantTasksPagination = pagination
	columns := this.PlantTaskPresenter.Columns("main")
	columns = this.Maestro.UpdateColumnsVisibility(columns, in.Request.Columns)
	out.Response.List.Columns = columns
	return true, nil
}
