package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/list_plant_tasks"
	"gardening/src/srv/fetchers"
)

type ListPlantTasksMae struct {
	AddPlantTaskSetToResponseStep *steps.AddPlantTaskSetToResponseStep
	AuthorizeStep                 *steps.AuthorizeStep
	Maestro                       *maestro.Maestro
	PlantTaskFetcher              *fetchers.PlantTaskFetcher
	SetupBreadcrumbStep           *steps.SetupBreadcrumbStep
}

func (this *ListPlantTasksMae) Act(ctx context.Context, in *maes.ListPlantTasksMaeIn) (*maes.ListPlantTasksMaeOut, error) {
	out := &maes.ListPlantTasksMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.ListPlantTasksMaeIn, out *maes.ListPlantTasksMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.AddPlantTaskSetToResponseStep.Act,
		this.SetupBreadcrumbStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
