package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/hydrators"
	"gardening/src/srv/presenters"
)

type AddPlantationSetToResponseStep struct {
	Maestro             *maestro.Maestro
	PlantationFetcher   *fetchers.PlantationFetcher
	PlantationHydrator  *hydrators.PlantationHydrator
	PlantationPresenter *presenters.PlantationPresenter
}

func (this *AddPlantationSetToResponseStep) Act(ctx context.Context, in *maes.ListPlantationsMaeIn, out *maes.ListPlantationsMaeOut) (bool, error) {
	mod := this.PlantationFetcher.Mod()
	mod.Page = in.Request.Page
	mod.PerPage = 15
	mod.AllowedFilters = this.PlantationPresenter.Filters(ctx)
	mod.ConvertRawFilters(in.Request.Filters)
	page, pagination, err := this.PlantationFetcher.FindPage(ctx, mod)
	if err != nil {
		return false, err
	}
	this.PlantationHydrator.ManyViaPreset(ctx, page, "list", nil)
	out.Response.Plantations = page
	out.Response.PlantationsPagination = pagination
	columns := this.PlantationPresenter.Columns("main")
	columns = this.Maestro.UpdateColumnsVisibility(columns, in.Request.Columns)
	out.Response.List.Columns = columns
	return true, nil
}
