package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/list_plantations"
	"gardening/src/srv/fetchers"
)

type ListPlantationsMae struct {
	AddPlantationSetToResponseStep *steps.AddPlantationSetToResponseStep
	AuthorizeStep                  *steps.AuthorizeStep
	Maestro                        *maestro.Maestro
	PlantationFetcher              *fetchers.PlantationFetcher
	SetupBreadcrumbStep            *steps.SetupBreadcrumbStep
}

func (this *ListPlantationsMae) Act(ctx context.Context, in *maes.ListPlantationsMaeIn) (*maes.ListPlantationsMaeOut, error) {
	out := &maes.ListPlantationsMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.ListPlantationsMaeIn, out *maes.ListPlantationsMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.AddPlantationSetToResponseStep.Act,
		this.SetupBreadcrumbStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
