package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/hydrators"
	"gardening/src/srv/presenters"
)

type AddPlantSetToResponseStep struct {
	Maestro        *maestro.Maestro
	PlantFetcher   *fetchers.PlantFetcher
	PlantHydrator  *hydrators.PlantHydrator
	PlantPresenter *presenters.PlantPresenter
}

func (this *AddPlantSetToResponseStep) Act(ctx context.Context, in *maes.ListPlantsMaeIn, out *maes.ListPlantsMaeOut) (bool, error) {
	mod := this.PlantFetcher.Mod()
	mod.Page = in.Request.Page
	mod.PerPage = 15
	mod.AllowedFilters = this.PlantPresenter.Filters(ctx)
	mod.ConvertRawFilters(in.Request.Filters)
	page, pagination, err := this.PlantFetcher.FindPage(ctx, mod)
	if err != nil {
		return false, err
	}
	this.PlantHydrator.ManyViaPreset(ctx, page, "list", nil)
	out.Response.Plants = page
	out.Response.PlantsPagination = pagination
	columns := this.PlantPresenter.Columns("main")
	columns = this.Maestro.UpdateColumnsVisibility(columns, in.Request.Columns)
	out.Response.List.Columns = columns
	return true, nil
}
