package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/list_plants"
	"gardening/src/srv/fetchers"
)

type ListPlantsMae struct {
	AddPlantSetToResponseStep *steps.AddPlantSetToResponseStep
	AuthorizeStep             *steps.AuthorizeStep
	Maestro                   *maestro.Maestro
	PlantFetcher              *fetchers.PlantFetcher
	SetupBreadcrumbStep       *steps.SetupBreadcrumbStep
}

func (this *ListPlantsMae) Act(ctx context.Context, in *maes.ListPlantsMaeIn) (*maes.ListPlantsMaeOut, error) {
	out := &maes.ListPlantsMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.ListPlantsMaeIn, out *maes.ListPlantsMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.AddPlantSetToResponseStep.Act,
		this.SetupBreadcrumbStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
