package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/hydrators"
	"gardening/src/srv/presenters"
)

type AddSeedProgramSetToResponseStep struct {
	Maestro              *maestro.Maestro
	SeedProgramFetcher   *fetchers.SeedProgramFetcher
	SeedProgramHydrator  *hydrators.SeedProgramHydrator
	SeedProgramPresenter *presenters.SeedProgramPresenter
}

func (this *AddSeedProgramSetToResponseStep) Act(ctx context.Context, in *maes.ListSeedProgramsMaeIn, out *maes.ListSeedProgramsMaeOut) (bool, error) {
	mod := this.SeedProgramFetcher.Mod()
	mod.Page = in.Request.Page
	mod.PerPage = 15
	mod.AllowedFilters = this.SeedProgramPresenter.Filters(ctx)
	mod.ConvertRawFilters(in.Request.Filters)
	page, pagination, err := this.SeedProgramFetcher.FindPage(ctx, mod)
	if err != nil {
		return false, err
	}
	this.SeedProgramHydrator.ManyViaPreset(ctx, page, "list", nil)
	out.Response.SeedPrograms = page
	out.Response.SeedProgramsPagination = pagination
	columns := this.SeedProgramPresenter.Columns("main")
	columns = this.Maestro.UpdateColumnsVisibility(columns, in.Request.Columns)
	out.Response.List.Columns = columns
	return true, nil
}
