package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/list_seed_programs"
	"gardening/src/srv/fetchers"
)

type ListSeedProgramsMae struct {
	AddSeedProgramSetToResponseStep *steps.AddSeedProgramSetToResponseStep
	AuthorizeStep                   *steps.AuthorizeStep
	Maestro                         *maestro.Maestro
	SeedProgramFetcher              *fetchers.SeedProgramFetcher
	SetupBreadcrumbStep             *steps.SetupBreadcrumbStep
}

func (this *ListSeedProgramsMae) Act(ctx context.Context, in *maes.ListSeedProgramsMaeIn) (*maes.ListSeedProgramsMaeOut, error) {
	out := &maes.ListSeedProgramsMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.ListSeedProgramsMaeIn, out *maes.ListSeedProgramsMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.AddSeedProgramSetToResponseStep.Act,
		this.SetupBreadcrumbStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
