package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/fetchers"
	"gardening/src/srv/hydrators"
	"gardening/src/srv/presenters"
)

type AddUserSetToResponseStep struct {
	Maestro       *maestro.Maestro
	UserFetcher   *fetchers.UserFetcher
	UserHydrator  *hydrators.UserHydrator
	UserPresenter *presenters.UserPresenter
}

func (this *AddUserSetToResponseStep) Act(ctx context.Context, in *maes.ListUsersMaeIn, out *maes.ListUsersMaeOut) (bool, error) {
	mod := this.UserFetcher.Mod()
	mod.Page = in.Request.Page
	mod.PerPage = 15
	mod.AllowedFilters = this.UserPresenter.Filters(ctx)
	mod.ConvertRawFilters(in.Request.Filters)
	page, pagination, err := this.UserFetcher.FindPage(ctx, mod)
	if err != nil {
		return false, err
	}
	this.UserHydrator.ManyViaPreset(ctx, page, "list", nil)
	out.Response.Users = page
	out.Response.UsersPagination = pagination
	columns := this.UserPresenter.Columns("main")
	columns = this.Maestro.UpdateColumnsVisibility(columns, in.Request.Columns)
	out.Response.List.Columns = columns
	return true, nil
}
