package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/list_users"
	"gardening/src/srv/fetchers"
)

type ListUsersMae struct {
	AddUserSetToResponseStep *steps.AddUserSetToResponseStep
	AuthorizeStep            *steps.AuthorizeStep
	Maestro                  *maestro.Maestro
	SetupBreadcrumbStep      *steps.SetupBreadcrumbStep
	UserFetcher              *fetchers.UserFetcher
}

func (this *ListUsersMae) Act(ctx context.Context, in *maes.ListUsersMaeIn) (*maes.ListUsersMaeOut, error) {
	out := &maes.ListUsersMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.ListUsersMaeIn, out *maes.ListUsersMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.AddUserSetToResponseStep.Act,
		this.SetupBreadcrumbStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
