package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/form_presenters"
)

type ConfigureFormStep struct {
	CreateGardenFormPresenter *form_presenters.CreateGardenFormPresenter
	Maestro                   *maestro.Maestro
}

func (this *ConfigureFormStep) Act(ctx context.Context, in *maes.NewGardenMaeIn, out *maes.NewGardenMaeOut) (bool, error) {
	out.Response.Form = in.Request.Form
	out.Response.FormBag = this.Maestro.EmptyFormBag()

	out.Response.FormFields = this.CreateGardenFormPresenter.Setup(&out.Response.Form)

	return true, nil
}
