package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/new_garden"
	"gardening/src/srv/fetchers"
)

type NewGardenMae struct {
	AuthorizeStep       *steps.AuthorizeStep
	ConfigureFormStep   *steps.ConfigureFormStep
	GardenFetcher       *fetchers.GardenFetcher
	Maestro             *maestro.Maestro
	SetupBreadcrumbStep *steps.SetupBreadcrumbStep
}

func (this *NewGardenMae) Act(ctx context.Context, in *maes.NewGardenMaeIn) (*maes.NewGardenMaeOut, error) {
	out := &maes.NewGardenMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.NewGardenMaeIn, out *maes.NewGardenMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ConfigureFormStep.Act,
		this.SetupBreadcrumbStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
