package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/new_garden_task"
	"gardening/src/srv/fetchers"
)

type NewGardenTaskMae struct {
	AuthorizeStep       *steps.AuthorizeStep
	ConfigureFormStep   *steps.ConfigureFormStep
	GardenTaskFetcher   *fetchers.GardenTaskFetcher
	Maestro             *maestro.Maestro
	SetupBreadcrumbStep *steps.SetupBreadcrumbStep
}

func (this *NewGardenTaskMae) Act(ctx context.Context, in *maes.NewGardenTaskMaeIn) (*maes.NewGardenTaskMaeOut, error) {
	out := &maes.NewGardenTaskMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.NewGardenTaskMaeIn, out *maes.NewGardenTaskMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ConfigureFormStep.Act,
		this.SetupBreadcrumbStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
