package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/new_plant"
	"gardening/src/srv/fetchers"
)

type NewPlantMae struct {
	AuthorizeStep       *steps.AuthorizeStep
	ConfigureFormStep   *steps.ConfigureFormStep
	Maestro             *maestro.Maestro
	PlantFetcher        *fetchers.PlantFetcher
	SetupBreadcrumbStep *steps.SetupBreadcrumbStep
}

func (this *NewPlantMae) Act(ctx context.Context, in *maes.NewPlantMaeIn) (*maes.NewPlantMaeOut, error) {
	out := &maes.NewPlantMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.NewPlantMaeIn, out *maes.NewPlantMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ConfigureFormStep.Act,
		this.SetupBreadcrumbStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
