package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/form_presenters"
)

type ConfigureFormStep struct {
	CreatePlantTaskFormPresenter *form_presenters.CreatePlantTaskFormPresenter
	Maestro                      *maestro.Maestro
}

func (this *ConfigureFormStep) Act(ctx context.Context, in *maes.NewPlantTaskMaeIn, out *maes.NewPlantTaskMaeOut) (bool, error) {
	out.Response.Form = in.Request.Form
	out.Response.FormBag = this.Maestro.EmptyFormBag()

	out.Response.FormFields = this.CreatePlantTaskFormPresenter.Setup(&out.Response.Form)

	return true, nil
}
