package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/new_plant_task"
	"gardening/src/srv/fetchers"
)

type NewPlantTaskMae struct {
	AuthorizeStep       *steps.AuthorizeStep
	ConfigureFormStep   *steps.ConfigureFormStep
	Maestro             *maestro.Maestro
	PlantTaskFetcher    *fetchers.PlantTaskFetcher
	SetupBreadcrumbStep *steps.SetupBreadcrumbStep
}

func (this *NewPlantTaskMae) Act(ctx context.Context, in *maes.NewPlantTaskMaeIn) (*maes.NewPlantTaskMaeOut, error) {
	out := &maes.NewPlantTaskMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.NewPlantTaskMaeIn, out *maes.NewPlantTaskMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ConfigureFormStep.Act,
		this.SetupBreadcrumbStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
