package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/new_plantation"
	"gardening/src/srv/fetchers"
)

type NewPlantationMae struct {
	AuthorizeStep       *steps.AuthorizeStep
	ConfigureFormStep   *steps.ConfigureFormStep
	Maestro             *maestro.Maestro
	PlantationFetcher   *fetchers.PlantationFetcher
	SetupBreadcrumbStep *steps.SetupBreadcrumbStep
}

func (this *NewPlantationMae) Act(ctx context.Context, in *maes.NewPlantationMaeIn) (*maes.NewPlantationMaeOut, error) {
	out := &maes.NewPlantationMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.NewPlantationMaeIn, out *maes.NewPlantationMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ConfigureFormStep.Act,
		this.SetupBreadcrumbStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
