package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/new_seed_program"
	"gardening/src/srv/fetchers"
)

type NewSeedProgramMae struct {
	AuthorizeStep       *steps.AuthorizeStep
	ConfigureFormStep   *steps.ConfigureFormStep
	Maestro             *maestro.Maestro
	SeedProgramFetcher  *fetchers.SeedProgramFetcher
	SetupBreadcrumbStep *steps.SetupBreadcrumbStep
}

func (this *NewSeedProgramMae) Act(ctx context.Context, in *maes.NewSeedProgramMaeIn) (*maes.NewSeedProgramMaeOut, error) {
	out := &maes.NewSeedProgramMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.NewSeedProgramMaeIn, out *maes.NewSeedProgramMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ConfigureFormStep.Act,
		this.SetupBreadcrumbStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
