package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/form_presenters"
)

type ConfigureFormStep struct {
	CreateUserFormPresenter *form_presenters.CreateUserFormPresenter
	Maestro                 *maestro.Maestro
}

func (this *ConfigureFormStep) Act(ctx context.Context, in *maes.NewUserMaeIn, out *maes.NewUserMaeOut) (bool, error) {
	out.Response.Form = in.Request.Form
	out.Response.FormBag = this.Maestro.EmptyFormBag()

	out.Response.FormFields = this.CreateUserFormPresenter.Setup(&out.Response.Form)

	return true, nil
}
