package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/new_user"
	"gardening/src/srv/fetchers"
)

type NewUserMae struct {
	AuthorizeStep       *steps.AuthorizeStep
	ConfigureFormStep   *steps.ConfigureFormStep
	Maestro             *maestro.Maestro
	SetupBreadcrumbStep *steps.SetupBreadcrumbStep
	UserFetcher         *fetchers.UserFetcher
}

func (this *NewUserMae) Act(ctx context.Context, in *maes.NewUserMaeIn) (*maes.NewUserMaeOut, error) {
	out := &maes.NewUserMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.NewUserMaeIn, out *maes.NewUserMaeOut) (bool, error){
		this.AuthorizeStep.Act,
		this.ConfigureFormStep.Act,
		this.SetupBreadcrumbStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
