package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/overview_storage"
)

type OverviewStorageMae struct {
	Maestro      *maestro.Maestro
	OverviewStep *steps.OverviewStep
}

func (this *OverviewStorageMae) Act(ctx context.Context, in *maes.OverviewStorageMaeIn) (*maes.OverviewStorageMaeOut, error) {
	out := &maes.OverviewStorageMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.OverviewStorageMaeIn, out *maes.OverviewStorageMaeOut) (bool, error){
		this.OverviewStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
