package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/form_presenters"
)

type ConfigureFormStep struct {
	Maestro                     *maestro.Maestro
	PerformAnalyseFormPresenter *form_presenters.PerformAnalyseFormPresenter
}

func (this *ConfigureFormStep) Act(ctx context.Context, in *maes.PerformAnalyseMaeIn, out *maes.PerformAnalyseMaeOut) (bool, error) {
	out.Response.FormScope.Form = in.Request.Form
	out.Response.FormScope.FormBag = this.Maestro.EmptyFormBag()

	out.Response.FormScope.FormFields = this.PerformAnalyseFormPresenter.Setup(&out.Response.FormScope.Form)

	return true, nil
}
