package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/form_validators"
)

type ValidateFormStep struct {
	Maestro                     *maestro.Maestro
	PerformAnalyseFormValidator *form_validators.PerformAnalyseFormValidator
}

func (this *ValidateFormStep) Act(ctx context.Context, in *maes.PerformAnalyseMaeIn, out *maes.PerformAnalyseMaeOut) (bool, error) {
	bag, err := this.PerformAnalyseFormValidator.Validate(ctx, &in.Request.Form)
	out.Response.FormScope.FormBag = bag
	if err != nil {
		this.Maestro.AddFailureMessage(&out.Extra, "Cannot submit form")
		return false, err
	}
	return true, nil
}
