package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/perform_analyse"
)

type PerformAnalyseMae struct {
	ConfigureFormStep *steps.ConfigureFormStep
	Maestro           *maestro.Maestro
	PerformStep       *steps.PerformStep
	ValidateFormStep  *steps.ValidateFormStep
}

func (this *PerformAnalyseMae) Act(ctx context.Context, in *maes.PerformAnalyseMaeIn) (*maes.PerformAnalyseMaeOut, error) {
	out := &maes.PerformAnalyseMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.PerformAnalyseMaeIn, out *maes.PerformAnalyseMaeOut) (bool, error){
		this.ConfigureFormStep.Act,
		this.ValidateFormStep.Act,
		this.PerformStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
