package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/form_presenters"
)

type ConfigureFormStep struct {
	Maestro                           *maestro.Maestro
	PerformImagesRoutineFormPresenter *form_presenters.PerformImagesRoutineFormPresenter
}

func (this *ConfigureFormStep) Act(ctx context.Context, in *maes.PerformImagesRoutineMaeIn, out *maes.PerformImagesRoutineMaeOut) (bool, error) {
	out.Response.FormScope.Form = in.Request.Form
	out.Response.FormScope.FormBag = this.Maestro.EmptyFormBag()

	out.Response.FormScope.FormFields = this.PerformImagesRoutineFormPresenter.Setup(&out.Response.FormScope.Form)

	return true, nil
}
