package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/form_validators"
)

type ValidateFormStep struct {
	Maestro                           *maestro.Maestro
	PerformImagesRoutineFormValidator *form_validators.PerformImagesRoutineFormValidator
}

func (this *ValidateFormStep) Act(ctx context.Context, in *maes.PerformImagesRoutineMaeIn, out *maes.PerformImagesRoutineMaeOut) (bool, error) {
	bag, err := this.PerformImagesRoutineFormValidator.Validate(ctx, &in.Request.Form)
	out.Response.FormScope.FormBag = bag
	if err != nil {
		this.Maestro.AddFailureMessage(&out.Extra, "Cannot submit form")
		return false, err
	}
	return true, nil
}
