package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/perform_images_routine"
)

type PerformImagesRoutineMae struct {
	ConfigureFormStep *steps.ConfigureFormStep
	Maestro           *maestro.Maestro
	PerformStep       *steps.PerformStep
	ValidateFormStep  *steps.ValidateFormStep
}

func (this *PerformImagesRoutineMae) Act(ctx context.Context, in *maes.PerformImagesRoutineMaeIn) (*maes.PerformImagesRoutineMaeOut, error) {
	out := &maes.PerformImagesRoutineMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.PerformImagesRoutineMaeIn, out *maes.PerformImagesRoutineMaeOut) (bool, error){
		this.ConfigureFormStep.Act,
		this.ValidateFormStep.Act,
		this.PerformStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
