package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/form_validators"
)

type ValidateFormStep struct {
	Maestro                         *maestro.Maestro
	PerformRenewOrdersFormValidator *form_validators.PerformRenewOrdersFormValidator
}

func (this *ValidateFormStep) Act(ctx context.Context, in *maes.PerformRenewOrdersMaeIn, out *maes.PerformRenewOrdersMaeOut) (bool, error) {
	bag, err := this.PerformRenewOrdersFormValidator.Validate(ctx, &in.Request.Form)
	out.Response.FormScope.FormBag = bag
	if err != nil {
		this.Maestro.AddFailureMessage(&out.Extra, "Cannot submit form")
		return false, err
	}
	return true, nil
}
