package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/perform_renew_orders"
)

type PerformRenewOrdersMae struct {
	ConfigureFormStep *steps.ConfigureFormStep
	Maestro           *maestro.Maestro
	PerformStep       *steps.PerformStep
	ValidateFormStep  *steps.ValidateFormStep
}

func (this *PerformRenewOrdersMae) Act(ctx context.Context, in *maes.PerformRenewOrdersMaeIn) (*maes.PerformRenewOrdersMaeOut, error) {
	out := &maes.PerformRenewOrdersMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.PerformRenewOrdersMaeIn, out *maes.PerformRenewOrdersMaeOut) (bool, error){
		this.ConfigureFormStep.Act,
		this.ValidateFormStep.Act,
		this.PerformStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
