package steps

// |@@| F

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/srv/form_presenters"
)

type ConfigureFormStep struct {
	Maestro                    *maestro.Maestro
	PerformEventsFormPresenter *form_presenters.PerformEventsFormPresenter
}

func (this *ConfigureFormStep) Act(ctx context.Context, in *maes.SeeEventsMaeIn, out *maes.SeeEventsMaeOut) (bool, error) {
	out.Response.FormScope.Form = in.Request.Form
	out.Response.FormScope.FormBag = this.Maestro.EmptyFormBag()

	out.Response.FormScope.FormFields = this.PerformEventsFormPresenter.Setup(&out.Response.FormScope.Form)

	return true, nil
}
