package mae

// |@@| C

import (
	"context"
	"gardening/src/dat/maes"
	"gardening/src/lib/maestro"
	"gardening/src/mae/see_events"
)

type SeeEventsMae struct {
	ConfigureFormStep *steps.ConfigureFormStep
	Maestro           *maestro.Maestro
	SeeStep           *steps.SeeStep
}

func (this *SeeEventsMae) Act(ctx context.Context, in *maes.SeeEventsMaeIn) (*maes.SeeEventsMaeOut, error) {
	out := &maes.SeeEventsMaeOut{In: in, Ctx: ctx}
	acts := []func(ctx context.Context, in *maes.SeeEventsMaeIn, out *maes.SeeEventsMaeOut) (bool, error){
		this.SeeStep.Act,
		this.ConfigureFormStep.Act,
	}
	out, err := maestro.ActOnActs(ctx, in, out, acts)
	if err != nil {
		return out, err
	}
	out.Success = true
	return out, nil
}
